// Copyright 2025 LiveKit, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// @generated by protoc-gen-es v1.10.1 with parameter "target=dts+js"
// @generated from file livekit_connector_twilio.proto (package livekit, syntax proto3)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto3 } from "@bufbuild/protobuf";
import type { RoomAgentDispatch } from "./livekit_agent_dispatch_pb.js";

/**
 * @generated from message livekit.ConnectTwilioCallRequest
 */
export declare class ConnectTwilioCallRequest extends Message<ConnectTwilioCallRequest> {
  /**
   * The Direction of the call
   *
   * @generated from field: livekit.ConnectTwilioCallRequest.TwilioCallDirection twilio_call_direction = 1;
   */
  twilioCallDirection: ConnectTwilioCallRequest_TwilioCallDirection;

  /**
   * What LiveKit room should this call be connected to
   *
   * @generated from field: string room_name = 2;
   */
  roomName: string;

  /**
   * Optional agents to dispatch the call to
   *
   * @generated from field: repeated livekit.RoomAgentDispatch agents = 3;
   */
  agents: RoomAgentDispatch[];

  /**
   * Optional identity of the participant in LiveKit room
   *
   * @generated from field: string participant_identity = 4;
   */
  participantIdentity: string;

  /**
   * Optional name of the participant in LiveKit room
   *
   * @generated from field: string participant_name = 5;
   */
  participantName: string;

  /**
   * Optional user-defined metadata. Will be attached to a created Participant in the room.
   *
   * @generated from field: string participant_metadata = 6;
   */
  participantMetadata: string;

  /**
   * Optional user-defined attributes. Will be attached to a created Participant in the room.
   *
   * @generated from field: map<string, string> participant_attributes = 7;
   */
  participantAttributes: { [key: string]: string };

  /**
   * Country where the call terminates as ISO 3166-1 alpha-2 (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will be used by the livekit infrastructure to route calls.
   *
   * @generated from field: string destination_country = 8;
   */
  destinationCountry: string;

  constructor(data?: PartialMessage<ConnectTwilioCallRequest>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ConnectTwilioCallRequest";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConnectTwilioCallRequest;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConnectTwilioCallRequest;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConnectTwilioCallRequest;

  static equals(a: ConnectTwilioCallRequest | PlainMessage<ConnectTwilioCallRequest> | undefined, b: ConnectTwilioCallRequest | PlainMessage<ConnectTwilioCallRequest> | undefined): boolean;
}

/**
 * @generated from enum livekit.ConnectTwilioCallRequest.TwilioCallDirection
 */
export declare enum ConnectTwilioCallRequest_TwilioCallDirection {
  /**
   * @generated from enum value: TWILIO_CALL_DIRECTION_INBOUND = 0;
   */
  INBOUND = 0,

  /**
   * @generated from enum value: TWILIO_CALL_DIRECTION_OUTBOUND = 1;
   */
  OUTBOUND = 1,
}

/**
 * @generated from message livekit.ConnectTwilioCallResponse
 */
export declare class ConnectTwilioCallResponse extends Message<ConnectTwilioCallResponse> {
  /**
   * The websocket URL which twilio media stream will connect to
   *
   * @generated from field: string connect_url = 1;
   */
  connectUrl: string;

  constructor(data?: PartialMessage<ConnectTwilioCallResponse>);

  static readonly runtime: typeof proto3;
  static readonly typeName = "livekit.ConnectTwilioCallResponse";
  static readonly fields: FieldList;

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConnectTwilioCallResponse;

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConnectTwilioCallResponse;

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConnectTwilioCallResponse;

  static equals(a: ConnectTwilioCallResponse | PlainMessage<ConnectTwilioCallResponse> | undefined, b: ConnectTwilioCallResponse | PlainMessage<ConnectTwilioCallResponse> | undefined): boolean;
}

